package com.bycom.versapro.MenuTypes.RSS.API;

import static com.bycom.versapro.MenuTypes.RSS.Adapters.RSSAdapter.ITEM_RSS;
import com.bycom.versapro.MenuTypes.RSS.Serializables.RSSItem;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.BufferedReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;

public class RSSParser {

    public static void parseRssFeed(String url,RSSFeedCallback callback) {
        ArrayList<RSSItem> rssItems = new ArrayList<>();

        try {
            String xmlContent = getResponse(new URL(url));


            Document document = Jsoup.parse(xmlContent, "", org.jsoup.parser.Parser.xmlParser());
            Elements itemElements = document.select("item, entry");

            for (Element itemElement : itemElements) {

                RSSItem rssItem = new RSSItem();


                Element titleElement = itemElement.selectFirst("title");
                if (titleElement != null) {
                    rssItem.setTitle(titleElement.text());
                }


                Element linkElement = itemElement.selectFirst("link");
                if (linkElement != null) {
                    if(linkElement.hasAttr("href"))
                        rssItem.setLink( linkElement.attr("href"));
                    else rssItem.setLink(linkElement.text());
                }


                Element viewsElement = itemElement.selectFirst("media|community > media|statistics");
                if(viewsElement != null && viewsElement.hasAttr("views")){
                    rssItem.setViews(viewsElement.attr("views"));
                }


                Element descriptionElement = itemElement.selectFirst("description, media|description");
                if (descriptionElement != null) {
                    rssItem.setDescription(descriptionElement.text());
                }

                Element thumbnailElement = itemElement.selectFirst("media|thumbnail");
                if (thumbnailElement != null && thumbnailElement.hasAttr("url")) {
                    rssItem.setThumbnailUrl(thumbnailElement.attr("url"));
                }

                Element dateElement = itemElement.selectFirst("pubDate, published, dc|date");
                if(dateElement != null){
                    rssItem.setDate(dateElement.text());
                }

                Element authorElement = itemElement.selectFirst("author > name, dc|creator");
                if(authorElement != null){
                    rssItem.setAuthor(authorElement.text());
                }

                Element contentElement = itemElement.selectFirst("content, content|encoded");
                if(contentElement != null){
                    rssItem.setContent(contentElement.text());
                }

                rssItem.setType(ITEM_RSS);

                rssItems.add(rssItem);


            }


            if(!rssItems.isEmpty()) callback.onSuccess(rssItems);
            else callback.onFailed();


        } catch (Exception e) {
            callback.onFailed();
        }


    }



    public static String getResponse(URL url) {
        try {
            HttpURLConnection connection = (HttpURLConnection) url.openConnection();
            connection.setRequestMethod("GET");

            int responseCode = connection.getResponseCode();

            InputStream inputStream;
            if (responseCode == HttpURLConnection.HTTP_OK) {
                inputStream = connection.getInputStream();
            } else {
                inputStream = connection.getErrorStream();
            }

            BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));
            StringBuilder response = new StringBuilder();
            String line;
            while ((line = reader.readLine()) != null) {
                response.append(line);
            }
            reader.close();

            return response.toString();

        } catch (Exception e) {
            return "Error: " + e.getMessage();
        }

    }




    public interface RSSFeedCallback{

        void onSuccess(ArrayList<RSSItem> rssItems);

        void onFailed();

    }




}
